<x-app-layout>
    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <h1 class="text-2xl font-bold text-gray-900 mb-6">Ilmoittautumislomake</h1>
                    
                    <form method="POST" action="{{ route('registration.store') }}">
                        @csrf
                        
                        <div class="mb-8">
                            <h2 class="text-xl font-semibold text-gray-800 mb-4">Lapsen tiedot</h2>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="child_name" class="block text-sm font-medium text-gray-700 mb-1">Lapsen nimi *</label>
                                    <input type="text" name="child_name" id="child_name" value="{{ old('child_name') }}" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    @error('child_name')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="child_birthdate" class="block text-sm font-medium text-gray-700 mb-1">Syntymäaika *</label>
                                    <input type="date" name="child_birthdate" id="child_birthdate" value="{{ old('child_birthdate') }}" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    @error('child_birthdate')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-8">
                            <h2 class="text-xl font-semibold text-gray-800 mb-4">Huoltajan tiedot</h2>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="guardian_name" class="block text-sm font-medium text-gray-700 mb-1">Huoltajan nimi *</label>
                                    <input type="text" name="guardian_name" id="guardian_name" value="{{ old('guardian_name') }}" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    @error('guardian_name')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Sähköposti *</label>
                                    <input type="email" name="email" id="email" value="{{ old('email') }}" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    @error('email')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="phone" class="block text-sm font-medium text-gray-700 mb-1">Puhelinnumero *</label>
                                    <input type="tel" name="phone" id="phone" value="{{ old('phone') }}" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    @error('phone')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="address" class="block text-sm font-medium text-gray-700 mb-1">Osoite *</label>
                                    <input type="text" name="address" id="address" value="{{ old('address') }}" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    @error('address')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-8">
                            <h2 class="text-xl font-semibold text-gray-800 mb-4">Hoitotiedot</h2>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Toivottu aloituspäivä *</label>
                                    <input type="date" name="start_date" id="start_date" value="{{ old('start_date') }}" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    @error('start_date')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="care_type" class="block text-sm font-medium text-gray-700 mb-1">Hoitomuoto *</label>
                                    <select name="care_type" id="care_type" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                        <option value="full" {{ old('care_type') == 'full' ? 'selected' : '' }}>Kokopäivähoito</option>
                                        <option value="part" {{ old('care_type') == 'part' ? 'selected' : '' }}>Osapäivähoito</option>
                                    </select>
                                    @error('care_type')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="special_diet" class="block text-sm font-medium text-gray-700 mb-1">Erityisruokavalio</label>
                                    <input type="text" name="special_diet" id="special_diet" value="{{ old('special_diet') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    @error('special_diet')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                                
                                <div>
                                    <label for="allergies" class="block text-sm font-medium text-gray-700 mb-1">Allergiat</label>
                                    <input type="text" name="allergies" id="allergies" value="{{ old('allergies') }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                    @error('allergies')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="mt-6">
                                <label for="additional_info" class="block text-sm font-medium text-gray-700 mb-1">Lisätietoja</label>
                                <textarea name="additional_info" id="additional_info" rows="4" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">{{ old('additional_info') }}</textarea>
                                @error('additional_info')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="mb-8">
                            <div class="flex items-start">
                                <div class="flex items-center h-5">
                                    <input id="terms_accepted" name="terms_accepted" type="checkbox" required class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                </div>
                                <div class="ml-3 text-sm">
                                    <label for="terms_accepted" class="font-medium text-gray-700">Hyväksyn tietojen käsittelyn *</label>
                                    <p class="text-gray-500">Hyväksyn, että antamiani tietoja käsitellään ilmoittautumisen käsittelemiseksi.</p>
                                    @error('terms_accepted')
                                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                Lähetä ilmoittautuminen
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
