<x-app-layout>
    <!-- Hero Section -->
    <section class="relative bg-blue-600 text-white">
        @if ($heroContent && $heroContent->image_path)
            <div class="absolute inset-0 z-0">
                <img src="{{ asset($heroContent->image_path) }}" alt="{{ $heroContent->title }}" class="w-full h-full object-cover opacity-40">
            </div>
        @endif
        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24 md:py-32">
            <div class="max-w-3xl">
                <h1 class="text-4xl md:text-5xl font-bold mb-6">{{ $heroContent->title ?? 'Tervetuloa Satakieli päiväkotiin' }}</h1>
                <p class="text-xl md:text-2xl mb-8">{{ $heroContent->content ?? 'Tarjoamme laadukasta varhaiskasvatusta turvallisessa ja viihtyisässä ympäristössä.' }}</p>
                <a href="{{ route('registration.form') }}" class="inline-block bg-white text-blue-600 font-bold py-3 px-6 rounded-lg shadow-lg hover:bg-blue-50 transition duration-300">
                    Ilmoittaudu nyt
                </a>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="py-16 md:py-24 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="lg:flex lg:items-center lg:space-x-12">
                <div class="lg:w-1/2 mb-10 lg:mb-0">
                    @if ($aboutContent && $aboutContent->image_path)
                        <img src="{{ asset($aboutContent->image_path) }}" alt="{{ $aboutContent->title }}" class="rounded-lg shadow-lg w-full h-auto">
                    @else
                        <div class="bg-gray-200 rounded-lg h-96 flex items-center justify-center">
                            <span class="text-gray-500">Kuva puuttuu</span>
                        </div>
                    @endif
                </div>
                <div class="lg:w-1/2">
                    <h2 class="text-3xl font-bold text-gray-900 mb-6">{{ $aboutContent->title ?? 'Tietoa meistä' }}</h2>
                    <div class="prose prose-lg max-w-none text-gray-600">
                        {!! nl2br(e($aboutContent->content ?? 'Sisältö puuttuu')) !!}
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="py-16 md:py-24 bg-gray-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl font-bold text-center text-gray-900 mb-12">Toimintamme</h2>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                @forelse ($servicesContent as $service)
                    <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                        @if ($service->image_path)
                            <img src="{{ asset($service->image_path) }}" alt="{{ $service->title }}" class="w-full h-48 object-cover">
                        @else
                            <div class="bg-gray-200 h-48 flex items-center justify-center">
                                <span class="text-gray-500">Kuva puuttuu</span>
                            </div>
                        @endif
                        <div class="p-6">
                            <h3 class="text-xl font-bold text-gray-900 mb-3">{{ $service->title }}</h3>
                            <p class="text-gray-600">{{ $service->content }}</p>
                        </div>
                    </div>
                @empty
                    <div class="col-span-3 text-center py-12">
                        <p class="text-gray-500">Ei sisältöä saatavilla.</p>
                    </div>
                @endforelse
            </div>
        </div>
    </section>

    <!-- Gallery Section -->
    <section class="py-16 md:py-24 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl font-bold text-center text-gray-900 mb-12">Galleria</h2>
            <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                @forelse ($galleryImages as $image)
                    <div class="relative overflow-hidden rounded-lg shadow-lg aspect-w-4 aspect-h-3">
                        @if ($image->image_path)
                            <img src="{{ asset($image->image_path) }}" alt="{{ $image->title }}" class="w-full h-full object-cover transition-transform duration-300 hover:scale-105">
                        @else
                            <div class="bg-gray-200 h-full flex items-center justify-center">
                                <span class="text-gray-500">Kuva puuttuu</span>
                            </div>
                        @endif
                    </div>
                @empty
                    <div class="col-span-3 text-center py-12">
                        <p class="text-gray-500">Ei kuvia saatavilla.</p>
                    </div>
                @endforelse
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="py-16 md:py-24 bg-gray-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="lg:flex lg:items-center lg:space-x-12">
                <div class="lg:w-1/2 mb-10 lg:mb-0">
                    <h2 class="text-3xl font-bold text-gray-900 mb-6">{{ $contactContent->title ?? 'Yhteystiedot' }}</h2>
                    <div class="prose prose-lg max-w-none text-gray-600 mb-8">
                        {!! nl2br(e($contactContent->content ?? 'Yhteystiedot puuttuvat')) !!}
                    </div>
                    <a href="{{ route('registration.form') }}" class="inline-block bg-blue-600 text-white font-bold py-3 px-6 rounded-lg shadow-lg hover:bg-blue-700 transition duration-300">
                        Ilmoittaudu nyt
                    </a>
                </div>
                <div class="lg:w-1/2">
                    <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1967.0615381743337!2d22.266510015860996!3d60.45196998196671!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x468c76fedc7b68c3%3A0x4024e0c9f5fa3855!2sTurun%20kaupunki!5e0!3m2!1sfi!2sfi!4v1626345678901!5m2!1sfi!2sfi" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
