<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Ilmoittautuminen vastaanotettu - Satakieli Päiväkoti</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #3b82f6;
            color: white;
            padding: 20px;
            text-align: center;
        }
        .content {
            padding: 20px;
            background-color: #f9fafb;
        }
        .footer {
            text-align: center;
            padding: 20px;
            font-size: 12px;
            color: #6b7280;
        }
        h1 {
            margin-top: 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table td {
            padding: 8px;
            border-bottom: 1px solid #e5e7eb;
        }
        table td:first-child {
            font-weight: bold;
            width: 40%;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Ilmoittautuminen vastaanotettu</h1>
        </div>
        
        <div class="content">
            <p>Hei {{ $registration->guardian_name }},</p>
            
            <p>Kiitos ilmoittautumisestasi Satakieli päiväkotiin. Olemme vastaanottaneet ilmoittautumisesi ja käsittelemme sen mahdollisimman pian.</p>
            
            <p>Tässä yhteenveto antamistasi tiedoista:</p>
            
            <table>
                <tr>
                    <td>Lapsen nimi:</td>
                    <td>{{ $registration->child_name }}</td>
                </tr>
                <tr>
                    <td>Lapsen syntymäaika:</td>
                    <td>{{ $registration->child_birthdate->format('d.m.Y') }}</td>
                </tr>
                <tr>
                    <td>Toivottu aloituspäivä:</td>
                    <td>{{ $registration->start_date->format('d.m.Y') }}</td>
                </tr>
                <tr>
                    <td>Hoitomuoto:</td>
                    <td>{{ $registration->care_type == 'full' ? 'Kokopäivähoito' : 'Osapäivähoito' }}</td>
                </tr>
            </table>
            
            <p>Otamme sinuun yhteyttä mahdollisimman pian ilmoittautumisesi käsittelyn jälkeen.</p>
            
            <p>Ystävällisin terveisin,<br>Satakieli päiväkodin henkilökunta</p>
        </div>
        
        <div class="footer">
            <p>Satakieli Päiväkoti | Esimerkkikatu 123, 20100 Turku | 050 123 4567 | info@satakieli.fi</p>
        </div>
    </div>
</body>
</html>
