<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Ilmoittautumisen tila päivitetty - Satakieli Päiväkoti</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #3b82f6;
            color: white;
            padding: 20px;
            text-align: center;
        }
        .content {
            padding: 20px;
            background-color: #f9fafb;
        }
        .footer {
            text-align: center;
            padding: 20px;
            font-size: 12px;
            color: #6b7280;
        }
        .status {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 9999px;
            font-weight: bold;
        }
        .status-accepted {
            background-color: #d1fae5;
            color: #065f46;
        }
        .status-rejected {
            background-color: #fee2e2;
            color: #b91c1c;
        }
        .status-pending {
            background-color: #fef3c7;
            color: #92400e;
        }
        h1 {
            margin-top: 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Ilmoittautumisen tila päivitetty</h1>
        </div>
        
        <div class="content">
            <p>Hei {{ $registration->guardian_name }},</p>
            
            <p>Ilmoittautumisesi Satakieli päiväkotiin on käsitelty ja sen tila on päivitetty.</p>
            
            <p>
                Ilmoittautumisen tila: 
                <span class="status {{ $registration->status == 'accepted' ? 'status-accepted' : ($registration->status == 'rejected' ? 'status-rejected' : 'status-pending') }}">
                    {{ $registration->status == 'accepted' ? 'Hyväksytty' : ($registration->status == 'rejected' ? 'Hylätty' : 'Odottaa') }}
                </span>
            </p>
            
            @if($registration->status == 'accepted')
                <p>Onnittelut! Lapsesi ilmoittautuminen on hyväksytty. Otamme sinuun pian yhteyttä sopiaksemme tarkemmista yksityiskohdista ja tutustumiskäynnistä.</p>
            @elseif($registration->status == 'rejected')
                <p>Valitettavasti emme pysty tällä hetkellä tarjoamaan hoitopaikkaa lapsellesi. Jos sinulla on kysyttävää, ota yhteyttä päiväkotiin.</p>
            @else
                <p>Ilmoittautumisesi on edelleen käsittelyssä. Ilmoitamme sinulle, kun päätös on tehty.</p>
            @endif
            
            <p>Ystävällisin terveisin,<br>Satakieli päiväkodin henkilökunta</p>
        </div>
        
        <div class="footer">
            <p>Satakieli Päiväkoti | Esimerkkikatu 123, 20100 Turku | 050 123 4567 | info@satakieli.fi</p>
        </div>
    </div>
</body>
</html>
