<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Ilmoittautumisen tiedot') }}
            </h2>
            <a href="{{ route('admin.registrations.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 active:bg-gray-900 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150">
                Takaisin
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6 bg-white border-b border-gray-200">
                    <div class="flex justify-between items-start mb-6">
                        <h3 class="text-lg font-medium text-gray-900">{{ $registration->child_name }}</h3>
                        <div>
                            @if($registration->status == 'pending')
                                <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">Odottaa</span>
                            @elseif($registration->status == 'accepted')
                                <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">Hyväksytty</span>
                            @else
                                <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">Hylätty</span>
                            @endif
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="text-sm font-medium text-gray-500 mb-2">Lapsen tiedot</h4>
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <div class="mb-3">
                                    <div class="text-xs text-gray-500">Nimi</div>
                                    <div class="font-medium">{{ $registration->child_name }}</div>
                                </div>
                                <div>
                                    <div class="text-xs text-gray-500">Syntymäaika</div>
                                    <div class="font-medium">{{ $registration->child_birthdate->format('d.m.Y') }}</div>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <h4 class="text-sm font-medium text-gray-500 mb-2">Huoltajan tiedot</h4>
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <div class="mb-3">
                                    <div class="text-xs text-gray-500">Nimi</div>
                                    <div class="font-medium">{{ $registration->guardian_name }}</div>
                                </div>
                                <div class="mb-3">
                                    <div class="text-xs text-gray-500">Sähköposti</div>
                                    <div class="font-medium">{{ $registration->email }}</div>
                                </div>
                                <div class="mb-3">
                                    <div class="text-xs text-gray-500">Puhelinnumero</div>
                                    <div class="font-medium">{{ $registration->phone }}</div>
                                </div>
                                <div>
                                    <div class="text-xs text-gray-500">Osoite</div>
                                    <div class="font-medium">{{ $registration->address }}</div>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <h4 class="text-sm font-medium text-gray-500 mb-2">Hoitotiedot</h4>
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <div class="mb-3">
                                    <div class="text-xs text-gray-500">Aloituspäivä</div>
                                    <div class="font-medium">{{ $registration->start_date->format('d.m.Y') }}</div>
                                </div>
                                <div class="mb-3">
                                    <div class="text-xs text-gray-500">Hoitomuoto</div>
                                    <div class="font-medium">{{ $registration->care_type == 'full' ? 'Kokopäivähoito' : 'Osapäivähoito' }}</div>
                                </div>
                                <div class="mb-3">
                                    <div class="text-xs text-gray-500">Erityisruokavalio</div>
                                    <div class="font-medium">{{ $registration->special_diet ?: 'Ei erityisruokavaliota' }}</div>
                                </div>
                                <div>
                                    <div class="text-xs text-gray-500">Allergiat</div>
                                    <div class="font-medium">{{ $registration->allergies ?: 'Ei allergioita' }}</div>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <h4 class="text-sm font-medium text-gray-500 mb-2">Lisätiedot</h4>
                            <div class="bg-gray-50 p-4 rounded-lg">
                                <div class="mb-3">
                                    <div class="text-xs text-gray-500">Ilmoittautumispäivä</div>
                                    <div class="font-medium">{{ $registration->created_at->format('d.m.Y H:i') }}</div>
                                </div>
                                <div>
                                    <div class="text-xs text-gray-500">Lisätietoja</div>
                                    <div class="font-medium">{{ $registration->additional_info ?: 'Ei lisätietoja' }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Päivitä tila</h3>
                    
                    <form method="POST" action="{{ route('admin.registrations.update-status', $registration) }}">
                        @csrf
                        @method('PATCH')
                        
                        <div class="mb-4">
                            <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Tila</label>
                            <select name="status" id="status" class="rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                <option value="pending" {{ $registration->status == 'pending' ? 'selected' : '' }}>Odottaa</option>
                                <option value="accepted" {{ $registration->status == 'accepted' ? 'selected' : '' }}>Hyväksytty</option>
                                <option value="rejected" {{ $registration->status == 'rejected' ? 'selected' : '' }}>Hylätty</option>
                            </select>
                        </div>
                        
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring ring-blue-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Päivitä tila
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
