<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Muokkaa sisältöä') }}
            </h2>
            <a href="{{ route('admin.content.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 active:bg-gray-900 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150">
                Takaisin
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form method="POST" action="{{ route('admin.content.update', $content) }}" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label for="section" class="block text-sm font-medium text-gray-700 mb-1">Osio *</label>
                                <select name="section" id="section" required class="rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 w-full">
                                    @foreach($sections as $section)
                                        <option value="{{ $section }}" {{ old('section', $content->section) == $section ? 'selected' : '' }}>
                                            @switch($section)
                                                @case('hero')
                                                    Etusivu (Hero)
                                                    @break
                                                @case('about')
                                                    Tietoa meistä
                                                    @break
                                                @case('services')
                                                    Palvelut
                                                    @break
                                                @case('gallery')
                                                    Galleria
                                                    @break
                                                @case('contact')
                                                    Yhteystiedot
                                                    @break
                                                @default
                                                    {{ $section }}
                                            @endswitch
                                        </option>
                                    @endforeach
                                </select>
                                @error('section')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Otsikko *</label>
                                <input type="text" name="title" id="title" value="{{ old('title', $content->title) }}" required class="rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 w-full">
                                @error('title')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label for="order" class="block text-sm font-medium text-gray-700 mb-1">Järjestys *</label>
                                <input type="number" name="order" id="order" value="{{ old('order', $content->order) }}" min="1" required class="rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 w-full">
                                @error('order')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label for="image" class="block text-sm font-medium text-gray-700 mb-1">Kuva</label>
                                @if($content->image_path)
                                    <div class="mb-2">
                                        <img src="{{ asset($content->image_path) }}" alt="{{ $content->title }}" class="h-20 w-auto">
                                    </div>
                                @endif
                                <input type="file" name="image" id="image" class="rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 w-full">
                                <p class="mt-1 text-sm text-gray-500">Jätä tyhjäksi säilyttääksesi nykyisen kuvan.</p>
                                @error('image')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div class="md:col-span-2">
                                <label for="content" class="block text-sm font-medium text-gray-700 mb-1">Sisältö</label>
                                <textarea name="content" id="content" rows="6" class="rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50 w-full">{{ old('content', $content->content) }}</textarea>
                                @error('content')
                                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div class="md:col-span-2">
                                <div class="flex items-start">
                                    <div class="flex items-center h-5">
                                        <input id="is_active" name="is_active" type="checkbox" {{ old('is_active', $content->is_active) ? 'checked' : '' }} class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                    </div>
                                    <div class="ml-3 text-sm">
                                        <label for="is_active" class="font-medium text-gray-700">Aktiivinen</label>
                                        <p class="text-gray-500">Näytetäänkö sisältö sivustolla.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring ring-blue-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Päivitä
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
