<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SiteContent;

class SiteContentSeeder extends Seeder
{
    public function run()
    {
        // Hero Section
        SiteContent::create([
            'section' => 'hero',
            'title' => 'Tervetuloa Satakieli päiväkotiin',
            'content' => 'Tarjoamme laadukasta varhaiskasvatusta turvallisessa ja viihtyisässä ympäristössä.',
            'image_path' => '/images/hero-image.jpg',
            'order' => 1,
            'is_active' => true,
        ]);

        // About Section
        SiteContent::create([
            'section' => 'about',
            'title' => 'Tietoa meistä',
            'content' => 'Satakieli päiväkoti on perustettu vuonna 2010 tarjoamaan laadukasta varhaiskasvatusta Turun alueella. Painotamme toiminnassamme luontokasvatusta, kielten oppimista ja taidekasvatusta. Henkilökuntamme koostuu koulutetuista varhaiskasvatuksen ammattilaisista, jotka ovat sitoutuneet lasten hyvinvoinnin edistämiseen.',
            'image_path' => '/images/about-image.jpg',
            'order' => 1,
            'is_active' => true,
        ]);

        // Services Section
        SiteContent::create([
            'section' => 'services',
            'title' => 'Luontokasvatus',
            'content' => 'Tutustumme luontoon säännöllisillä retkillä ja opimme kunnioittamaan ympäristöä.',
            'image_path' => '/images/nature-education.jpg',
            'order' => 1,
            'is_active' => true,
        ]);

        SiteContent::create([
            'section' => 'services',
            'title' => 'Kielikasvatus',
            'content' => 'Tutustumme suomen kielen lisäksi englannin ja ruotsin kieliin leikin kautta.',
            'image_path' => '/images/language-education.jpg',
            'order' => 2,
            'is_active' => true,
        ]);

        SiteContent::create([
            'section' => 'services',
            'title' => 'Taidekasvatus',
            'content' => 'Kehitämme luovuutta ja itseilmaisua monipuolisen taidekasvatuksen avulla.',
            'image_path' => '/images/art-education.jpg',
            'order' => 3,
            'is_active' => true,
        ]);

        // Gallery Images
        for ($i = 1; $i <= 6; $i++) {
            SiteContent::create([
                'section' => 'gallery',
                'title' => "Galleriakuva $i",
                'content' => "Kuvaus galleriakuvalle $i",
                'image_path' => "/images/gallery-$i.jpg",
                'order' => $i,
                'is_active' => true,
            ]);
        }

        // Contact Section
        SiteContent::create([
            'section' => 'contact',
            'title' => 'Yhteystiedot',
            'content' => "Satakieli päiväkoti\nEsimerkkikatu 123\n20100 Turku\n\nPuh: 050 123 4567\nEmail: info@satakieli.fi\n\nAukioloajat:\nMa-Pe: 7:00-17:00",
            'image_path' => '/images/contact-image.jpg',
            'order' => 1,
            'is_active' => true,
        ]);
    }
}
