<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Registration;
use Carbon\Carbon;

class RegistrationSeeder extends Seeder
{
    public function run()
    {
        Registration::create([
            'child_name' => 'Matti Meikäläinen',
            'child_birthdate' => Carbon::parse('2019-05-15'),
            'guardian_name' => 'Liisa Meikäläinen',
            'email' => 'liisa.meikalainen@example.com',
            'phone' => '+358 50 123 4567',
            'address' => 'Esimerkkikatu 1, 20100 Turku',
            'start_date' => Carbon::parse('2023-08-15'),
            'care_type' => 'full',
            'special_diet' => 'Laktoositon',
            'allergies' => 'Pähkinät',
            'additional_info' => 'Pitää erityisesti ulkoilusta ja piirtämisestä.',
            'terms_accepted' => true,
            'status' => 'pending',
            'created_at' => Carbon::parse('2023-05-10 10:30:00'),
        ]);

        Registration::create([
            'child_name' => 'Anna Virtanen',
            'child_birthdate' => Carbon::parse('2020-02-20'),
            'guardian_name' => 'Mikko Virtanen',
            'email' => 'mikko.virtanen@example.com',
            'phone' => '+358 40 987 6543',
            'address' => 'Puistokatu 5, 20100 Turku',
            'start_date' => Carbon::parse('2023-09-01'),
            'care_type' => 'part',
            'special_diet' => '',
            'allergies' => '',
            'additional_info' => 'Ujo uusissa tilanteissa.',
            'terms_accepted' => true,
            'status' => 'accepted',
            'created_at' => Carbon::parse('2023-06-05 14:15:00'),
        ]);
    }
}
