<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('registrations', function (Blueprint $table) {
            $table->id();
            $table->string('child_name');
            $table->date('child_birthdate');
            $table->string('guardian_name');
            $table->string('email');
            $table->string('phone', 20);
            $table->string('address');
            $table->date('start_date');
            $table->enum('care_type', ['full', 'part']);
            $table->string('special_diet')->nullable();
            $table->string('allergies')->nullable();
            $table->text('additional_info')->nullable();
            $table->boolean('terms_accepted');
            $table->enum('status', ['pending', 'accepted', 'rejected'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('registrations');
    }
};
