"use client"

import { useState, useEffect } from "react"
import Link from "next/link"
import { Menu, X } from "lucide-react"
import { ClientImage } from "./client-image"

const navItems = [
  { label: "Etusivu", href: "/" },
  { label: "Tietoa meistä", href: "/tietoa-meista" },
  { label: "Palvelut", href: "/palvelut" },
  { label: "Rekisteröinti", href: "/rekisterointi" },
  { label: "Yhteystiedot", href: "/yhteystiedot" },
  { label: "Course", href: "https://www.healthonlinelearning.com/", external: true },
]

export function Header() {
  const [isMenuOpen, setIsMenuOpen] = useState(false)
  const [currentLogo, setCurrentLogo] = useState(0)

  const logos = ["/images/logo-pink.jpeg", "/images/logo-yellow.jpeg", "/images/logo-blue.jpeg"]
  const logoColors = ["bg-pink-500", "bg-yellow-500", "bg-blue-500"]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentLogo((prev) => (prev + 1) % logos.length)
    }, 3000)
    return () => clearInterval(interval)
  }, [])

  return (
    <header className="bg-white shadow-sm sticky top-0 z-50">
      <div className="container mx-auto px-4">
        <div className="flex justify-between items-center h-16">
          <Link href="/" className="flex items-center space-x-2">
            <div className="relative w-10 h-10 rounded-full overflow-hidden">
              <ClientImage
                src={logos[currentLogo] || "/placeholder.svg"}
                alt="Satakieli Logo"
                width={40}
                height={40}
                className="object-cover"
                fallback={
                  <div className={`w-full h-full flex items-center justify-center ${logoColors[currentLogo]}`}>
                    <span className="text-white font-bold">S</span>
                  </div>
                }
              />
            </div>
            <div>
              <span className="font-bold text-lg text-gray-900">Satakieli</span>
              <span className="block text-xs text-gray-500">Päiväkoti</span>
            </div>
          </Link>

          {/* Desktop Navigation */}
          <nav className="hidden md:flex space-x-1">
            {navItems.map((item) =>
              item.external ? (
                <a
                  key={item.href}
                  href={item.href}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="px-3 py-2 rounded-md text-sm font-medium text-gray-700 hover:bg-rainbow-red/10 hover:text-rainbow-red transition-colors"
                >
                  {item.label}
                </a>
              ) : (
                <Link
                  key={item.href}
                  href={item.href}
                  className="px-3 py-2 rounded-md text-sm font-medium text-gray-700 hover:bg-rainbow-red/10 hover:text-rainbow-red transition-colors"
                >
                  {item.label}
                </Link>
              ),
            )}
          </nav>

          {/* Mobile menu button */}
          <button
            className="md:hidden p-2 rounded-md text-gray-700 hover:bg-gray-100"
            onClick={() => setIsMenuOpen(!isMenuOpen)}
            aria-label={isMenuOpen ? "Close menu" : "Open menu"}
          >
            {isMenuOpen ? <X className="h-6 w-6" /> : <Menu className="h-6 w-6" />}
          </button>
        </div>

        {/* Mobile Navigation */}
        {isMenuOpen && (
          <div className="md:hidden py-3 border-t border-gray-100">
            <nav className="flex flex-col space-y-1 pb-3">
              {navItems.map((item) =>
                item.external ? (
                  <a
                    key={item.href}
                    href={item.href}
                    target="_blank"
                    rel="noopener noreferrer"
                    className="px-3 py-2 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-100"
                    onClick={() => setIsMenuOpen(false)}
                  >
                    {item.label}
                  </a>
                ) : (
                  <Link
                    key={item.href}
                    href={item.href}
                    className="px-3 py-2 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-100"
                    onClick={() => setIsMenuOpen(false)}
                  >
                    {item.label}
                  </Link>
                ),
              )}
            </nav>
          </div>
        )}
      </div>
    </header>
  )
}
