import Link from "next/link"
import { Phone, Mail, MapPin, Clock } from "lucide-react"
import { ClientImage } from "./client-image"

export function Footer() {
  return (
    <footer className="bg-gradient-to-r from-rainbow-blue to-rainbow-indigo text-white py-12">
      <div className="container mx-auto px-4">
        <div className="grid md:grid-cols-4 gap-8">
          <div>
            <div className="flex items-center mb-4">
              <div className="relative w-10 h-10 bg-white rounded-full flex items-center justify-center mr-3 overflow-hidden">
                <ClientImage
                  src="/images/logo-blue.jpeg"
                  alt="Satakieli Logo"
                  width={40}
                  height={40}
                  className="object-cover"
                  fallback={<span className="text-rainbow-blue text-xl font-bold">S</span>}
                />
              </div>
              <div>
                <h3 className="text-xl font-bold">Satakieli</h3>
                <p className="text-blue-100 text-sm">Kieliä tiedostava päiväkoti</p>
              </div>
            </div>
            <p className="text-blue-100 mb-4">
              Tarjoamme laadukasta varhaiskasvatusta turvallisessa ja virikkeellisessä ympäristössä.
            </p>
            <div className="flex items-center mb-2">
              <Phone className="h-4 w-4 mr-2 text-blue-200" />
              <span className="text-sm text-blue-100">+358 50 123 4567</span>
            </div>
            <div className="flex items-center mb-2">
              <Mail className="h-4 w-4 mr-2 text-blue-200" />
              <span className="text-sm text-blue-100">info@brahensatakieli.fi</span>
            </div>
            <div className="flex items-center">
              <MapPin className="h-4 w-4 mr-2 text-blue-200" />
              <a
                href="https://maps.app.goo.gl/AryPJz4FZGSfddM69?g_st=aw"
                target="_blank"
                rel="noopener noreferrer"
                className="text-sm text-blue-100 hover:text-white"
              >
                Brahenkatu 20, 20100 Turku
              </a>
            </div>
          </div>
          <div>
            <h3 className="text-xl font-bold mb-4">Aukioloajat</h3>
            <div className="flex items-center mb-2">
              <Clock className="h-4 w-4 mr-2 text-blue-200" />
              <span className="text-sm text-blue-100">Ma-Pe: 7:00 - 17:00</span>
            </div>
            <div className="flex items-center">
              <Clock className="h-4 w-4 mr-2 text-blue-200" />
              <span className="text-sm text-blue-100">La-Su: Suljettu</span>
            </div>
            <h3 className="text-xl font-bold mt-6 mb-4">Seuraa meitä</h3>
            <div className="flex space-x-4">
              <a
                href="#"
                className="w-8 h-8 bg-blue-700 rounded-full flex items-center justify-center hover:bg-blue-600 transition-colors duration-300"
              >
                <svg className="h-4 w-4 text-white" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                  <path
                    fillRule="evenodd"
                    d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z"
                    clipRule="evenodd"
                  />
                </svg>
              </a>
              <a
                href="#"
                className="w-8 h-8 bg-blue-700 rounded-full flex items-center justify-center hover:bg-blue-600 transition-colors duration-300"
              >
                <svg className="h-4 w-4 text-white" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                  <path
                    fillRule="evenodd"
                    d="M12.315 2c2.43 0 2.784.013 3.808.06 1.064.049 1.791.218 2.427.465a4.902 4.902 0 011.772 1.153 4.902 4.902 0 011.153 1.772c.247.636.416 1.363.465 2.427.048 1.067.06 1.407.06 4.123v.08c0 2.643-.012 2.987-.06 4.043-.049 1.064-.218 1.791-.465 2.427a4.902 4.902 0 01-1.153 1.772 4.902 4.902 0 01-1.772 1.153c-.636.247-1.363.416-2.427.465-1.067.048-1.407.06-4.123.06h-.08c-2.643 0-2.987-.012-4.043-.06-1.064-.049-1.791-.218-2.427-.465a4.902 4.902 0 01-1.772-1.153 4.902 4.902 0 01-1.153-1.772c-.247-.636-.416-1.363-.465-2.427-.048-1.067-.06-1.407-.06-4.123v-.08c0-2.643.012-2.987.06-4.043.049-1.064.218-1.791.465-2.427a4.902 4.902 0 011.153-1.772A4.902 4.902 0 016.878 3.43c.636-.247 1.363-.416 2.427-.465 1.067-.048 1.407-.06 4.123-.06h.08z"
                    clipRule="evenodd"
                  />
                  <path d="M12 15.75a3.75 3.75 0 100-7.5 3.75 3.75 0 000 7.5z" />
                </svg>
              </a>
            </div>
          </div>
          <div>
            <h3 className="text-xl font-bold mb-4">Sivut</h3>
            <ul className="space-y-2">
              <li>
                <Link href="/" className="text-blue-100 hover:text-white transition-colors duration-200">
                  Etusivu
                </Link>
              </li>
              <li>
                <Link href="/tietoa-meista" className="text-blue-100 hover:text-white transition-colors duration-200">
                  Tietoa meistä
                </Link>
              </li>
              <li>
                <Link href="/palvelut" className="text-blue-100 hover:text-white transition-colors duration-200">
                  Palvelut
                </Link>
              </li>
              <li>
                <Link href="/rekisterointi" className="text-blue-100 hover:text-white transition-colors duration-200">
                  Rekisteröinti
                </Link>
              </li>
              <li>
                <Link href="/yhteystiedot" className="text-blue-100 hover:text-white transition-colors duration-200">
                  Yhteystiedot
                </Link>
              </li>
              <li>
                <a
                  href="https://www.healthonlinelearning.com/"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-blue-100 hover:text-white transition-colors duration-200"
                >
                  Course
                </a>
              </li>
            </ul>
          </div>
          <div>
            <h3 className="text-xl font-bold mb-4">Lisätietoa</h3>
            <ul className="space-y-2">
              <li>
                <Link
                  href="/tietosuojaseloste"
                  className="text-blue-100 hover:text-white transition-colors duration-200"
                >
                  Tietosuojaseloste
                </Link>
              </li>
              <li>
                <Link href="#" className="text-blue-100 hover:text-white transition-colors duration-200">
                  Käyttöehdot
                </Link>
              </li>
              <li>
                <Link href="#" className="text-blue-100 hover:text-white transition-colors duration-200">
                  Saavutettavuusseloste
                </Link>
              </li>
            </ul>
          </div>
        </div>
        <div className="border-t border-blue-700 mt-8 pt-6 text-center text-sm text-blue-200">
          <p>© {new Date().getFullYear()} Satakieli. Kaikki oikeudet pidätetään.</p>
        </div>
      </div>
    </footer>
  )
}
