"use client"

import type React from "react"

import Image from "next/image"
import { useState } from "react"

interface ClientImageProps {
  src: string
  alt: string
  width: number
  height: number
  className?: string
  fallback?: React.ReactNode
}

export function ClientImage({ src, alt, width, height, className, fallback }: ClientImageProps) {
  const [error, setError] = useState(false)

  if (error) {
    return <>{fallback}</>
  }

  return (
    <Image
      src={src || "/placeholder.svg"}
      alt={alt}
      width={width}
      height={height}
      className={className}
      onError={() => setError(true)}
    />
  )
}
