"use client"

import Link from "next/link"
import { usePathname, useRouter } from "next/navigation"
import { Button } from "@/components/ui/button"
import { LayoutDashboard, Users, FileText, Settings, ImageIcon, LogOut } from "lucide-react"

const navItems = [
  { name: "Dashboard", href: "/admin/dashboard", icon: LayoutDashboard },
  { name: "Rekisteröinnit", href: "/admin/registrations", icon: Users },
  { name: "Sisältö", href: "/admin/content", icon: FileText },
  { name: "Media", href: "/admin/media", icon: ImageIcon },
  { name: "Asetukset", href: "/admin/settings", icon: Settings },
]

export function AdminSidebar() {
  const pathname = usePathname()
  const router = useRouter()

  const handleLogout = () => {
    localStorage.removeItem("admin_auth")
    router.push("/admin/login")
  }

  return (
    <div className="w-64 bg-white border-r border-gray-200 flex flex-col h-full">
      <div className="p-4 border-b">
        <h1 className="text-xl font-bold">Satakieli Admin</h1>
      </div>

      <nav className="flex-1 p-4 space-y-1">
        {navItems.map((item) => {
          const isActive = pathname === item.href
          return (
            <Link
              key={item.href}
              href={item.href}
              className={`flex items-center px-3 py-2 rounded-md text-sm font-medium ${
                isActive ? "bg-rainbow-blue text-white" : "text-gray-700 hover:bg-gray-100"
              }`}
            >
              <item.icon className="h-5 w-5 mr-2" />
              {item.name}
            </Link>
          )
        })}
      </nav>

      <div className="p-4 border-t">
        <Button onClick={handleLogout} variant="outline" className="w-full flex items-center justify-center">
          <LogOut className="h-4 w-4 mr-2" />
          Kirjaudu ulos
        </Button>
      </div>
    </div>
  )
}
