"use client"

import type React from "react"

import { useEffect } from "react"
import { useRouter } from "next/navigation"

export function AdminAuthCheck({ children }: { children: React.ReactNode }) {
  const router = useRouter()

  useEffect(() => {
    // Check if user is authenticated
    const isAuthenticated = localStorage.getItem("admin_auth") === "true"

    if (!isAuthenticated) {
      router.push("/admin/login")
    }
  }, [router])

  return <>{children}</>
}
