"use client"

import { useEffect, useState } from "react"
import Link from "next/link"
import { Button } from "@/components/ui/button"
import { MapPin, Phone, Mail, Clock } from "lucide-react"
import dataService, { type SiteContent } from "@/app/lib/data-service"

export default function ContactPage() {
  const [content, setContent] = useState<SiteContent | null>(null)
  const [isLoading, setIsLoading] = useState(true)

  useEffect(() => {
    // Initialize sample data if needed
    dataService.initializeWithSampleData()

    // Load content
    const data = dataService.getSiteContent()
    setContent(data)
    setIsLoading(false)
  }, [])

  if (isLoading || !content) {
    return <div className="container mx-auto py-10 px-4">Loading...</div>
  }

  return (
    <div className="container mx-auto py-10">
      <h1 className="text-3xl font-bold mb-6 text-center">Yhteystiedot</h1>

      <div className="grid md:grid-cols-2 gap-8">
        <div className="bg-white p-6 rounded-lg shadow-md">
          <h2 className="text-2xl font-semibold mb-4">Ota yhteyttä</h2>

          <div className="space-y-4">
            <div className="flex items-start">
              <MapPin className="h-5 w-5 mr-2 text-pink-500 mt-1" />
              <div>
                <p className="font-medium">Osoite</p>
                <p>{content.contact.address}</p>
                <Link href={content.contact.mapUrl} target="_blank" rel="noopener noreferrer">
                  <Button variant="link" className="p-0 h-auto text-pink-500">
                    Avaa Google Maps
                  </Button>
                </Link>
              </div>
            </div>

            <div className="flex items-start">
              <Phone className="h-5 w-5 mr-2 text-yellow-500 mt-1" />
              <div>
                <p className="font-medium">Puhelin</p>
                <p>{content.contact.phone}</p>
              </div>
            </div>

            <div className="flex items-start">
              <Mail className="h-5 w-5 mr-2 text-blue-500 mt-1" />
              <div>
                <p className="font-medium">Sähköposti</p>
                <p>{content.contact.email}</p>
              </div>
            </div>

            <div className="flex items-start">
              <Clock className="h-5 w-5 mr-2 text-green-500 mt-1" />
              <div>
                <p className="font-medium">Aukioloajat</p>
                <p>{content.contact.hours}</p>
              </div>
            </div>
          </div>
        </div>

        <div className="bg-white p-6 rounded-lg shadow-md">
          <h2 className="text-2xl font-semibold mb-4">Sijainti</h2>
          <div className="aspect-video bg-gray-200 rounded-md overflow-hidden">
            <iframe
              src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1968.0533850940705!2d22.2672406!3d60.4539066!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x468c76fedc7d1f2d%3A0x8d93762d491d5282!2sBrahenkatu%2020%2C%2020100%20Turku!5e0!3m2!1sfi!2sfi!4v1652345678901!5m2!1sfi!2sfi"
              width="100%"
              height="100%"
              style={{ border: 0 }}
              allowFullScreen
              loading="lazy"
              referrerPolicy="no-referrer-when-downgrade"
            ></iframe>
          </div>
          <div className="mt-4">
            <p className="text-sm text-gray-600">
              Päiväkotimme sijaitsee keskeisellä paikalla Turussa, lähellä julkisia liikenneyhteyksiä ja puistoja.
            </p>
          </div>
        </div>
      </div>
    </div>
  )
}
