"use client"

import { useEffect, useState } from "react"
import Image from "next/image"
import dataService, { type SiteContent } from "@/app/lib/data-service"

export default function AboutPage() {
  const [content, setContent] = useState<SiteContent | null>(null)
  const [isLoading, setIsLoading] = useState(true)

  useEffect(() => {
    // Initialize sample data if needed
    dataService.initializeWithSampleData()

    // Load content
    const data = dataService.getSiteContent()
    setContent(data)
    setIsLoading(false)
  }, [])

  if (isLoading || !content) {
    return <div className="container mx-auto py-10 px-4">Loading...</div>
  }

  return (
    <div className="container mx-auto py-10">
      <h1 className="text-3xl font-bold mb-6 text-center">Tietoa meistä</h1>

      <div className="grid md:grid-cols-2 gap-8 mb-12">
        <div>
          <h2 className="text-2xl font-semibold mb-4">Satakieli päiväkoti</h2>
          <p className="mb-4">{content.about.mainText}</p>
          <p className="mb-4">
            Toimintamme perustuu lapsilähtöisyyteen ja yksilölliseen huomioimiseen. Uskomme, että jokainen lapsi on
            ainutlaatuinen ja ansaitsee tulla nähdyksi ja kuulluksi omana itsenään.
          </p>
          <p>
            Päiväkodissamme työskentelee ammattitaitoinen ja motivoitunut henkilökunta, joka huolehtii lapsista lämmöllä
            ja asiantuntemuksella.
          </p>
        </div>
        <div className="relative h-64 md:h-auto rounded-lg overflow-hidden">
          <Image
            src="/images/child-playground.jpeg"
            alt="Lapsi leikkimässä leikkipuistossa"
            fill
            className="object-cover"
          />
        </div>
      </div>

      <div className="grid md:grid-cols-3 gap-8 mb-12">
        <div className="bg-pink-50 p-6 rounded-lg">
          <h3 className="text-xl font-semibold mb-3">Toiminta-ajatus</h3>
          <p>{content.about.mission}</p>
        </div>
        <div className="bg-yellow-50 p-6 rounded-lg">
          <h3 className="text-xl font-semibold mb-3">Arvot</h3>
          <ul className="list-disc list-inside space-y-2">
            <li>Turvallisuus</li>
            <li>Yksilöllisyys</li>
            <li>Yhteisöllisyys</li>
            <li>Leikki ja ilo</li>
            <li>Kunnioitus ja välittäminen</li>
          </ul>
        </div>
        <div className="bg-blue-50 p-6 rounded-lg">
          <h3 className="text-xl font-semibold mb-3">Visio</h3>
          <p>{content.about.vision}</p>
        </div>
      </div>

      <div className="mb-12">
        <h2 className="text-2xl font-semibold mb-4">Henkilökunta</h2>
        <p className="mb-4">
          Päiväkodissamme työskentelee varhaiskasvatuksen ammattilaisia, joilla on vankka kokemus ja osaaminen lasten
          parissa työskentelystä. Henkilökuntaamme kuuluu:
        </p>
        <ul className="list-disc list-inside space-y-2 mb-4">
          <li>Varhaiskasvatuksen opettajia</li>
          <li>Lastenhoitajia</li>
          <li>Erityisvarhaiskasvatuksen opettaja</li>
          <li>Keittiöhenkilökuntaa</li>
        </ul>
        <p>
          Henkilökuntamme osallistuu säännöllisesti täydennyskoulutuksiin varmistaakseen ajantasaisen osaamisen ja
          laadukkaan varhaiskasvatuksen.
        </p>
      </div>

      <div>
        <h2 className="text-2xl font-semibold mb-4">Tilat ja ympäristö</h2>
        <p className="mb-4">
          Päiväkotimme tilat on suunniteltu lasten tarpeita ajatellen. Meillä on viihtyisät ja turvalliset sisätilat
          sekä monipuolinen piha-alue, joka mahdollistaa päivittäisen ulkoilun ja liikunnan.
        </p>
        <p className="mb-4">
          Hyödynnämme aktiivisesti myös lähiympäristön tarjoamia mahdollisuuksia, kuten puistoja, metsiä ja
          kulttuurikohteita. Teemme säännöllisesti retkiä lähiympäristöön.
        </p>
        <p>
          Päiväkodissamme tarjotaan monipuolista ja terveellistä ruokaa, joka valmistetaan omassa keittiössämme
          tuoreista raaka-aineista.
        </p>
      </div>
    </div>
  )
}
