"use client"

import { useEffect, useState } from "react"
import Image from "next/image"
import { Button } from "@/components/ui/button"
import Link from "next/link"
import dataService, { type SiteContent } from "@/app/lib/data-service"

export default function ServicesPage() {
  const [content, setContent] = useState<SiteContent | null>(null)
  const [isLoading, setIsLoading] = useState(true)

  useEffect(() => {
    // Initialize sample data if needed
    dataService.initializeWithSampleData()

    // Load content
    const data = dataService.getSiteContent()
    setContent(data)
    setIsLoading(false)
  }, [])

  if (isLoading || !content) {
    return <div className="container mx-auto py-10 px-4">Loading...</div>
  }

  return (
    <div className="container mx-auto py-10">
      <h1 className="text-3xl font-bold mb-6 text-center">Palvelut</h1>

      <div className="grid md:grid-cols-2 gap-8 mb-12">
        <div>
          <h2 className="text-2xl font-semibold mb-4">Varhaiskasvatuspalvelumme</h2>
          <p className="mb-4">{content.services.mainText}</p>
          <p className="mb-4">
            Päiväkodissamme lapset saavat kasvaa ja kehittyä turvallisessa ja virikkeellisessä ympäristössä
            ammattitaitoisen henkilökunnan ohjauksessa.
          </p>
          <p>
            Toimintamme noudattaa valtakunnallista varhaiskasvatussuunnitelmaa, ja jokaiselle lapselle laaditaan
            henkilökohtainen varhaiskasvatussuunnitelma yhteistyössä vanhempien kanssa.
          </p>
        </div>
        <div className="relative h-64 md:h-auto rounded-lg overflow-hidden">
          <Image
            src="/images/children-ballpit.jpeg"
            alt="Lapset leikkimässä pallomeressä"
            fill
            className="object-cover"
          />
        </div>
      </div>

      <div className="mb-12">
        <h2 className="text-2xl font-semibold mb-6 text-center">Palvelutarjontamme</h2>
        <div className="grid md:grid-cols-3 gap-6">
          <div className="bg-rainbow-red/10 p-6 rounded-lg">
            <h3 className="text-xl font-semibold mb-3 text-rainbow-red">Kokopäivähoito</h3>
            <p className="mb-4">
              Tarjoamme kokopäivähoitoa arkipäivisin klo 7:00-17:00. Kokopäivähoito sisältää aamupalan, lounaan ja
              välipalan.
            </p>
            <ul className="list-disc list-inside space-y-1 text-gray-700">
              <li>Monipuolista toimintaa koko päivän ajan</li>
              <li>Säännöllinen päivärytmi</li>
              <li>Lepohetki lounaan jälkeen</li>
              <li>Päivittäinen ulkoilu</li>
            </ul>
          </div>

          <div className="bg-rainbow-yellow/10 p-6 rounded-lg">
            <h3 className="text-xl font-semibold mb-3 text-rainbow-yellow">Osapäivähoito</h3>
            <p className="mb-4">
              Osapäivähoito on tarkoitettu perheille, jotka tarvitsevat hoitoa vain osan päivästä. Osapäivähoito voi
              olla joko aamu- tai iltapäivisin.
            </p>
            <ul className="list-disc list-inside space-y-1 text-gray-700">
              <li>Joustava hoitoaika (max. 5h/päivä)</li>
              <li>Yksi ateria ja välipala</li>
              <li>Ohjattua toimintaa</li>
              <li>Ulkoilua sään salliessa</li>
            </ul>
          </div>

          <div className="bg-rainbow-blue/10 p-6 rounded-lg">
            <h3 className="text-xl font-semibold mb-3 text-rainbow-blue">Esiopetus</h3>
            <p className="mb-4">
              Esiopetus on suunnattu 6-vuotiaille lapsille. Esiopetusta järjestetään arkipäivisin klo 9:00-13:00.
            </p>
            <ul className="list-disc list-inside space-y-1 text-gray-700">
              <li>Maksutonta esiopetusta</li>
              <li>Kouluvalmiuksien harjoittelua</li>
              <li>Mahdollisuus täydentävään varhaiskasvatukseen</li>
              <li>Yhteistyö lähikoulujen kanssa</li>
            </ul>
          </div>
        </div>
      </div>

      <div className="mb-12">
        <h2 className="text-2xl font-semibold mb-6">Toimintamme</h2>
        <div className="grid md:grid-cols-2 gap-8">
          <div className="space-y-4">
            <h3 className="text-xl font-semibold">Päivittäinen toiminta</h3>
            <p>
              Päiväkotimme arki koostuu monipuolisesta toiminnasta, joka tukee lapsen kasvua ja kehitystä. Toimintaamme
              kuuluu:
            </p>
            <ul className="list-disc list-inside space-y-2">
              <li>Ohjattua toimintaa pienryhmissä</li>
              <li>Leikkiä sisällä ja ulkona</li>
              <li>Musiikkia, liikuntaa ja taidetta</li>
              <li>Retkiä lähiympäristöön</li>
              <li>Projekteja ja teemapäiviä</li>
            </ul>
          </div>
          <div className="space-y-4">
            <h3 className="text-xl font-semibold">Erityispalvelut</h3>
            <p>Tarjoamme myös erityispalveluita lasten ja perheiden yksilöllisiin tarpeisiin:</p>
            <ul className="list-disc list-inside space-y-2">
              {content.services.servicesList.map((service, index) => (
                <li key={index}>{service}</li>
              ))}
            </ul>
          </div>
        </div>
      </div>

      <div className="bg-gradient-to-r from-rainbow-indigo/20 to-rainbow-violet/20 p-8 rounded-lg">
        <h2 className="text-2xl font-semibold mb-4 text-center">Kiinnostuitko palveluistamme?</h2>
        <p className="text-center mb-6">
          Ota yhteyttä tai rekisteröi lapsesi päiväkotiimme. Vastaamme mielellämme kysymyksiisi ja kerromme lisää
          palveluistamme.
        </p>
        <div className="flex flex-col sm:flex-row justify-center gap-4">
          <Button asChild className="bg-rainbow-violet hover:bg-rainbow-violet/90">
            <Link href="/rekisterointi">Rekisteröi lapsesi</Link>
          </Button>
          <Button asChild variant="outline">
            <Link href="/yhteystiedot">Ota yhteyttä</Link>
          </Button>
        </div>
      </div>
    </div>
  )
}
