"use server"

import { cookies } from "next/headers"
import { redirect } from "next/navigation"

// In a real app, you would store these securely in a database
// This is just for demonstration purposes
const ADMIN_USERNAME = "admin"
const ADMIN_PASSWORD = "satakieli2024"

// Session duration in seconds (24 hours)
const SESSION_DURATION = 60 * 60 * 24

export async function login(formData: FormData) {
  const username = formData.get("username") as string
  const password = formData.get("password") as string

  if (username === ADMIN_USERNAME && password === ADMIN_PASSWORD) {
    // Create a simple session token (in a real app, use a proper JWT or session system)
    const sessionToken = Buffer.from(
      JSON.stringify({
        username,
        exp: Date.now() + SESSION_DURATION * 1000,
      }),
    ).toString("base64")

    // Set the session cookie
    cookies().set("admin_session", sessionToken, {
      httpOnly: true,
      secure: process.env.NODE_ENV === "production",
      maxAge: SESSION_DURATION,
      path: "/",
    })

    return { success: true }
  }

  return { success: false, error: "Virheellinen käyttäjätunnus tai salasana" }
}

export async function logout() {
  cookies().delete("admin_session")
  redirect("/admin/login")
}

export async function getSession() {
  const sessionCookie = cookies().get("admin_session")

  if (!sessionCookie) {
    return null
  }

  try {
    const sessionData = JSON.parse(Buffer.from(sessionCookie.value, "base64").toString())

    // Check if session has expired
    if (sessionData.exp < Date.now()) {
      cookies().delete("admin_session")
      return null
    }

    return sessionData
  } catch (error) {
    return null
  }
}

export async function requireAuth() {
  const session = await getSession()

  if (!session) {
    redirect("/admin/login")
  }

  return session
}
