"use client"

import type React from "react"

import { useState } from "react"
import { useRouter } from "next/navigation"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Label } from "@/components/ui/label"
import { Alert, AlertDescription } from "@/components/ui/alert"
import { AlertCircle } from "lucide-react"

// Simple in-memory auth for demo purposes
const ADMIN_USERNAME = "admin"
const ADMIN_PASSWORD = "satakieli2024"

export default function LoginPage() {
  const router = useRouter()
  const [error, setError] = useState<string | null>(null)
  const [isLoading, setIsLoading] = useState(false)

  async function handleSubmit(event: React.FormEvent<HTMLFormElement>) {
    event.preventDefault()
    setIsLoading(true)
    setError(null)

    const formData = new FormData(event.currentTarget)
    const username = formData.get("username") as string
    const password = formData.get("password") as string

    // Simple client-side auth for demo
    if (username === ADMIN_USERNAME && password === ADMIN_PASSWORD) {
      // Store auth in localStorage for demo purposes
      localStorage.setItem("admin_auth", "true")
      router.push("/admin/dashboard")
    } else {
      setError("Virheellinen käyttäjätunnus tai salasana")
      setIsLoading(false)
    }
  }

  return (
    <div className="min-h-screen flex items-center justify-center bg-gradient-to-r from-rainbow-blue/10 to-rainbow-violet/10">
      <div className="w-full max-w-md p-8 space-y-8 bg-white rounded-lg shadow-lg">
        <div className="text-center">
          <h1 className="text-2xl font-bold">Satakieli Päiväkoti</h1>
          <p className="text-gray-600">Hallintapaneeli</p>
        </div>

        {error && (
          <Alert variant="destructive">
            <AlertCircle className="h-4 w-4" />
            <AlertDescription>{error}</AlertDescription>
          </Alert>
        )}

        <form onSubmit={handleSubmit} className="space-y-6">
          <div className="space-y-2">
            <Label htmlFor="username">Käyttäjätunnus</Label>
            <Input id="username" name="username" type="text" required autoComplete="username" />
          </div>

          <div className="space-y-2">
            <Label htmlFor="password">Salasana</Label>
            <Input id="password" name="password" type="password" required autoComplete="current-password" />
          </div>

          <Button type="submit" className="w-full" disabled={isLoading}>
            {isLoading ? "Kirjaudutaan..." : "Kirjaudu sisään"}
          </Button>
        </form>
      </div>
    </div>
  )
}
