"use server"

// This is a server action, but we'll use client-side data service in the client components
// In a real app, this would connect to a database

// Modified registration action that doesn't rely on file system
// Instead, it simulates successful registration

type RegistrationData = {
  id?: string
  childName: string
  childBirthdate: string
  guardianName: string
  email: string
  phone: string
  address: string
  startDate: string
  careType: string
  specialDiet?: string
  allergies?: string
  additionalInfo?: string
  termsAccepted: boolean
  status?: string
  createdAt?: string
}

// In-memory storage for registrations (will be reset on server restart)
const registrations: RegistrationData[] = []

export async function submitRegistration(formData: FormData) {
  try {
    // Create a unique ID for the registration (simple timestamp-based ID)
    const registrationId = Date.now().toString()

    // In a real app, we would save this to a database
    // For now, we'll just return success

    return {
      success: true,
      message: "Rekisteröinti onnistui! Otamme sinuun yhteyttä pian.",
    }
  } catch (error) {
    console.error("Registration error:", error)
    return {
      success: false,
      message: "Rekisteröinti epäonnistui. Yritä myöhemmin uudelleen.",
    }
  }
}

export async function getRegistrations() {
  // Return the in-memory registrations
  return registrations.sort((a, b) => {
    // Sort by creation date (newest first)
    return new Date(b.createdAt || "").getTime() - new Date(a.createdAt || "").getTime()
  })
}

export async function getRegistrationById(id: string) {
  return registrations.find((reg) => reg.id === id) || null
}

export async function updateRegistrationStatus(id: string, status: string) {
  try {
    const registration = registrations.find((reg) => reg.id === id)

    if (!registration) {
      return {
        success: false,
        message: "Rekisteröintiä ei löydy",
      }
    }

    registration.status = status

    return {
      success: true,
      message: "Tila päivitetty onnistuneesti",
    }
  } catch (error) {
    console.error(`Error updating registration ${id}:`, error)
    return {
      success: false,
      message: "Tilan päivitys epäonnistui",
    }
  }
}
