<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Registration extends Model
{
    use HasFactory;

    protected $fillable = [
        'child_name',
        'child_birthdate',
        'guardian_name',
        'email',
        'phone',
        'address',
        'start_date',
        'care_type',
        'special_diet',
        'allergies',
        'additional_info',
        'terms_accepted',
        'status',
    ];

    protected $casts = [
        'child_birthdate' => 'date',
        'start_date' => 'date',
        'terms_accepted' => 'boolean',
    ];
}
