<?php

namespace App\Http\Controllers;

use App\Models\Registration;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\RegistrationSubmitted;
use App\Mail\RegistrationStatusUpdated;

class RegistrationController extends Controller
{
    public function showForm()
    {
        return view('registration.form');
    }
    
    public function store(Request $request)
    {
        $validated = $request->validate([
            'child_name' => 'required|string|max:255',
            'child_birthdate' => 'required|date',
            'guardian_name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'address' => 'required|string|max:255',
            'start_date' => 'required|date',
            'care_type' => 'required|in:full,part',
            'special_diet' => 'nullable|string|max:255',
            'allergies' => 'nullable|string|max:255',
            'additional_info' => 'nullable|string',
            'terms_accepted' => 'required|accepted',
        ]);
        
        $validated['status'] = 'pending';
        
        $registration = Registration::create($validated);
        
        // Send confirmation email
        Mail::to($request->email)->send(new RegistrationSubmitted($registration));
        
        return redirect()->route('registration.success');
    }
    
    public function success()
    {
        return view('registration.success');
    }
}
