<?php

namespace App\Http\Controllers;

use App\Models\SiteContent;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $heroContent = SiteContent::where('section', 'hero')
            ->where('is_active', true)
            ->orderBy('order')
            ->first();
            
        $aboutContent = SiteContent::where('section', 'about')
            ->where('is_active', true)
            ->orderBy('order')
            ->first();
            
        $servicesContent = SiteContent::where('section', 'services')
            ->where('is_active', true)
            ->orderBy('order')
            ->get();
            
        $galleryImages = SiteContent::where('section', 'gallery')
            ->where('is_active', true)
            ->orderBy('order')
            ->get();
            
        $contactContent = SiteContent::where('section', 'contact')
            ->where('is_active', true)
            ->orderBy('order')
            ->first();
            
        return view('home', compact(
            'heroContent',
            'aboutContent',
            'servicesContent',
            'galleryImages',
            'contactContent'
        ));
    }
}
