<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Registration;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\RegistrationStatusUpdated;

class RegistrationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('admin');
    }
    
    public function index()
    {
        $registrations = Registration::orderBy('created_at', 'desc')->paginate(10);
        return view('admin.registrations.index', compact('registrations'));
    }
    
    public function show(Registration $registration)
    {
        return view('admin.registrations.show', compact('registration'));
    }
    
    public function updateStatus(Request $request, Registration $registration)
    {
        $validated = $request->validate([
            'status' => 'required|in:pending,accepted,rejected',
        ]);
        
        $registration->update($validated);
        
        // Send status update email
        Mail::to($registration->email)->send(new RegistrationStatusUpdated($registration));
        
        return redirect()->route('admin.registrations.show', $registration)
            ->with('success', 'Registration status updated successfully.');
    }
}
