<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Registration;
use App\Models\SiteContent;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('admin');
    }
    
    public function index()
    {
        $pendingRegistrations = Registration::where('status', 'pending')->count();
        $totalRegistrations = Registration::count();
        $contentSections = SiteContent::select('section')->distinct()->count();
        
        return view('admin.dashboard', compact(
            'pendingRegistrations',
            'totalRegistrations',
            'contentSections'
        ));
    }
}
